/******************************************************************************* 
*  ļΪSPISDĵײļ
*  SPIģ鼰IOĳʼSPIдSDдָݵȣ
*******************************************************************************/ 
/* Includes ------------------------------------------------------------------*/
#include "stm32f10x_lib.h"
#include "SPI_SD_driver.h"
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/

/* Private variables ---------------------------------------------------------*/
u8  SD_Type=0;
/* Private function prototypes -----------------------------------------------*/

/* Private functions ---------------------------------------------------------*/


////////////////////////////////////////////////////////////////////////////////
// SPIģĳʼ룬óģʽSD/TP
////////////////////////////////////////////////////////////////////////////////
/*******************************************************************************
* Function Name  : SPI_Configuration
* Description    : SPIģʼIOڵĳʼ
* Input          : None
* Output         : None
* Return         : None
*******************************************************************************/
void SPI_Configuration(void)
{
	SPI_InitTypeDef  SPI_InitStructure;
        GPIO_InitTypeDef GPIO_InitStructure;
	//SPI 2 ʱ
        RCC_APB2PeriphClockCmd(RCC_APB2Periph_GPIOB  |RCC_APB2Periph_GPIOC ,ENABLE);
        RCC_APB1PeriphClockCmd( RCC_APB2Periph_AFIO |RCC_APB1Periph_SPI2,ENABLE);
       /* Configure SPI1 pins: NSS, SCK, MISO and MOSI */
        GPIO_InitStructure.GPIO_Pin = GPIO_Pin_13 | GPIO_Pin_14 | GPIO_Pin_15;
        GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
        GPIO_InitStructure.GPIO_Mode = GPIO_Mode_AF_PP;
        GPIO_Init(GPIOB, &GPIO_InitStructure);

        ///TF Ƭѡ CS  PB12
        GPIO_InitStructure.GPIO_Pin = GPIO_Pin_12;
        GPIO_InitStructure.GPIO_Speed = GPIO_Speed_50MHz;
        GPIO_InitStructure.GPIO_Mode = GPIO_Mode_Out_PP;
        GPIO_Init(GPIOB, &GPIO_InitStructure);

	//PC6: SD⣨δգͣPAڲ
	GPIO_InitStructure.GPIO_Pin = GPIO_Pin_6;
	GPIO_InitStructure.GPIO_Mode = GPIO_Mode_IPU;
	GPIO_Init(GPIOC, &GPIO_InitStructure); 	

    //////SPIģ//////
    //һʼSDʼ׶ΣSPIʱƵʱ<400K
	SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
	SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
	SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;
	SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
	SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_256;
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial = 7;
	SPI_Init(SPI2, &SPI_InitStructure);

	SPI_Cmd(SPI2, ENABLE);
	return;
}

/*******************************************************************************
* Function Name  : SPI_SetSpeed
* Description    : SPIٶΪ
* Input          : u8 SpeedSet 
*                  ٶ0ģʽ0ģʽ
*                  SPI_SPEED_HIGH   1
*                  SPI_SPEED_LOW    0
* Output         : None
* Return         : None
*******************************************************************************/
void SPI_SetSpeed(u8 SpeedSet)
{
    SPI_InitTypeDef SPI_InitStructure;

    SPI_InitStructure.SPI_Direction = SPI_Direction_2Lines_FullDuplex;
	SPI_InitStructure.SPI_Mode = SPI_Mode_Master;
	SPI_InitStructure.SPI_DataSize = SPI_DataSize_8b;
	SPI_InitStructure.SPI_CPOL = SPI_CPOL_High;
	SPI_InitStructure.SPI_CPHA = SPI_CPHA_2Edge;
	SPI_InitStructure.SPI_NSS = SPI_NSS_Soft;
    //ٶ0ģʽ0ģʽ
    if(SpeedSet==SPI_SPEED_LOW)
    {
        SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_256;
    }
    else
    {
        SPI_InitStructure.SPI_BaudRatePrescaler = SPI_BaudRatePrescaler_2;
    }
	SPI_InitStructure.SPI_FirstBit = SPI_FirstBit_MSB;
	SPI_InitStructure.SPI_CRCPolynomial = 7;
	SPI_Init(SPI2, &SPI_InitStructure);
    return;
}


/*******************************************************************************
* Function Name  : SPI_ReadWriteByte
* Description    : SPIдһֽڣɺ󷵻رͨѶȡݣ
* Input          : u8 TxData ͵
* Output         : None
* Return         : u8 RxData յ
*******************************************************************************/
u8 SPI_ReadWriteByte(u8 TxData)
{
    u8 RxData = 0;
    /*
    //ȴͻ
    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_TXE) == RESET);
    //һֽ
    SPI_I2S_SendData(SPI2, TxData);
    //ȴݽ
    while(SPI_I2S_GetFlagStatus(SPI2, SPI_I2S_FLAG_RXNE) == RESET);
    //ȡ
    RxData = SPI_I2S_ReceiveData(SPI2); 
    */
    ///////////////ֱӲ  ٶȸ/////////////////
    while((SPI2->SR&SPI_I2S_FLAG_TXE)==RESET);
    SPI2->DR = TxData;
    while((SPI2->SR&SPI_I2S_FLAG_RXNE)==RESET);
    RxData =SPI2->DR;
    /////////////////////////////////////////////
    return (u8)RxData;
}

/*******************************************************************************
* Function Name  : SD_WaitReady
* Description    : ȴSDReady
* Input          : None
* Output         : None
* Return         : u8 
*                   0 ɹ
*                   otherʧ
*******************************************************************************/
u8 SD_WaitReady(void)
{
    u8 r1;
    u16 retry;
    retry = 0;
    do
    {
        r1 = SPI_ReadWriteByte(0xFF);
        if(retry==0xfffe)
        {
            return 1;
        }
    }while(r1!=0xFF);

    return 0;
}



/*******************************************************************************
* Function Name  : SD_SendCommand
* Description    : SDһ
* Input          : u8 cmd    
*                  u32 arg  
*                  u8 crc   crcУֵ
* Output         : None
* Return         : u8 r1 SDصӦ
*******************************************************************************/
u8 SD_SendCommand(u8 cmd, u32 arg, u8 crc)
{
    unsigned char r1;
    unsigned char Retry = 0;

    //????????
    SPI_ReadWriteByte(0xff);
    //ƬѡõͣѡSD
    SD_CS_ENABLE();

    //
    SPI_ReadWriteByte(cmd | 0x40);                         //ֱд
    SPI_ReadWriteByte(arg >> 24);
    SPI_ReadWriteByte(arg >> 16);
    SPI_ReadWriteByte(arg >> 8);
    SPI_ReadWriteByte(arg);
    SPI_ReadWriteByte(crc);
    
    //ȴӦʱ˳
    while((r1 = SPI_ReadWriteByte(0xFF))==0xFF)
    {
        Retry++;
        if(Retry > 200)
        {
            break;
        }
    }
    

    //رƬѡ
    SD_CS_DISABLE();
    //϶8ʱӣSDʣµĹ
    SPI_ReadWriteByte(0xFF);

    //״ֵ̬
    return r1;
}


/*******************************************************************************
* Function Name  : SD_SendCommand_NoDeassert
* Description    : SDһ(ǲʧƬѡкݴ
* Input          : u8 cmd    
*                  u32 arg  
*                  u8 crc   crcУֵ
* Output         : None
* Return         : u8 r1 SDصӦ
*******************************************************************************/
u8 SD_SendCommand_NoDeassert(u8 cmd, u32 arg, u8 crc)
{
    unsigned char r1;
    unsigned char Retry = 0;

    //????????
    SPI_ReadWriteByte(0xff);
    //ƬѡõͣѡSD
    SD_CS_ENABLE();

    //
    SPI_ReadWriteByte(cmd | 0x40);                         //ֱд
    SPI_ReadWriteByte(arg >> 24);
    SPI_ReadWriteByte(arg >> 16);
    SPI_ReadWriteByte(arg >> 8);
    SPI_ReadWriteByte(arg);
    SPI_ReadWriteByte(crc);

    //ȴӦʱ˳
    while((r1 = SPI_ReadWriteByte(0xFF))==0xFF)
    {
        Retry++;
        if(Retry > 200)
        {
            break;
        }
    }
    //Ӧֵ
    return r1;
}

/*******************************************************************************
* Function Name  : SD_Init
* Description    : ʼSD
* Input          : None
* Output         : None
* Return         : u8 
*                  0NO_ERR
*                  1TIME_OUT
*                  99NO_CARD
*******************************************************************************/
u8 SD_Init(void)
{
    u16 i;      // ѭ
    u8 r1;      // SDķֵ
    u16 retry;  // гʱ
    u8 buff[6];

    //ûм⵽룬ֱ˳ش־
    if(!SD_DET())
    {
        //return 99;        
        return (0x02);  //  FatFS־ûв
    }
                
     SPI_SetSpeed(0); //SPIΪģʽ
     SD_CS_ENABLE() ;
    //SDϵ
    //SD_PWR_ON();
    // ʱȴSDϵ
    for(i=0;i<0xf00;i++);

    //Ȳ>74壬SDԼʼ
    for(i=0;i<10;i++)
    {
        SPI_ReadWriteByte(0xFF);
    }

    //-----------------SDλidleʼ-----------------
    //ѭCMD0ֱSD0x01,IDLE״̬
    //ʱֱ˳
    retry = 0;
    do
    {
        //CMD0SDIDLE״̬
        r1 = SD_SendCommand(CMD0, 0, 0x95);
        retry++;
    }while((r1 != 0x01) && (retry<200));
    //ѭ󣬼ԭ򣺳ʼɹor Գʱ
    if(retry==200)
    {
        return 1;   //ʱ1
    }
    //-----------------SDλidle-----------------



    //ȡƬSD汾Ϣ
    r1 = SD_SendCommand_NoDeassert(8, 0x1aa, 0x87);

    //Ƭ汾Ϣv1.0汾ģr1=0x05³ʼ
    if(r1 == 0x05)
    {
        //ÿΪSDV1.0⵽ΪMMC޸ΪMMC
        SD_Type = SD_TYPE_V1;

        //V1.0CMD8ָûк
        //Ƭѡøߣ
        SD_CS_DISABLE();
        //෢8CLKSD
        SPI_ReadWriteByte(0xFF);

        //-----------------SDMMCʼʼ-----------------

        //ʼָCMD55+ACMD41
        // Ӧ˵SDҳʼ
        // ûлӦ˵MMCӦʼ
        retry = 0;
        do
        {
            //ȷCMD55Ӧ0x01
            r1 = SD_SendCommand(CMD55, 0, 0);
            if(r1 != 0x01)
            {
                return r1;  
            }
            //õȷӦ󣬷ACMD41Ӧõֵ0x00200
            r1 = SD_SendCommand(ACMD41, 0, 0);
            retry++;
        }while((r1!=0x00) && (retry<400));
        // жǳʱǵõȷӦ
        // лӦSDûлӦMMC
        
        //----------MMCʼʼ------------
        if(retry==400)
        {
            retry = 0;
            //MMCʼûвԣ
            do
            {
                r1 = SD_SendCommand(1, 0, 0);
                retry++;
            }while((r1!=0x00)&& (retry<400));
            if(retry==400)
            {
                return 1;   //MMCʼʱ
            }
            //д뿨
            SD_Type = SD_TYPE_MMC;
        }
        //----------MMCʼ------------
        
        //SPIΪģʽ
        SPI_SetSpeed(1);

		SPI_ReadWriteByte(0xFF);
        
        //ֹCRCУ
        /**/ 
		r1 = SD_SendCommand(CMD59, 0, 0x95);
        if(r1 != 0x00)
        {
            return r1;  //󣬷r1
        }
           
        //Sector Size
        r1 = SD_SendCommand(CMD16, 512, 0x95);
        if(r1 != 0x00)
        {
            return r1;  //󣬷r1
        }
        //-----------------SDMMCʼ-----------------

    }//SDΪV1.0汾ĳʼ
    

    //V2.0ĳʼ
    //ҪȡOCRݣжSD2.0SD2.0HC
    else if(r1 == 0x01)
    {
        //V2.0ĿCMD8ᴫ4ֽڵݣҪٽ
        buff[0] = SPI_ReadWriteByte(0xFF);  //should be 0x00
        buff[1] = SPI_ReadWriteByte(0xFF);  //should be 0x00
        buff[2] = SPI_ReadWriteByte(0xFF);  //should be 0x01
        buff[3] = SPI_ReadWriteByte(0xFF);  //should be 0xAA
     
        SD_CS_DISABLE();
        //the next 8 clocks
        SPI_ReadWriteByte(0xFF);
        
        //жϸÿǷ֧2.7V-3.6VĵѹΧ
        if(buff[2]==0x01 && buff[3]==0xAA)
        {
            //ֵ֧ѹΧԲ
            retry = 0;
            //ʼָCMD55+ACMD41
    		do
    		{
    			r1 = SD_SendCommand(CMD55, 0, 0);
    			if(r1!=0x01)
    			{
    				return r1;
    			}
    			r1 = SD_SendCommand(ACMD41, 0x40000000, 0);
                if(retry>200)   
                {
                    return r1;  //ʱ򷵻r1״̬
                }
            }while(r1!=0);
          
            //ʼָɣȡOCRϢ

            //-----------SD2.0汾ʼ-----------
            r1 = SD_SendCommand_NoDeassert(CMD58, 0, 0);
            if(r1!=0x00)
            {
                return r1;  //ûзȷӦֱ˳Ӧ
            }
            //OCRָ󣬽4ֽڵOCRϢ
            buff[0] = SPI_ReadWriteByte(0xFF);
            buff[1] = SPI_ReadWriteByte(0xFF); 
            buff[2] = SPI_ReadWriteByte(0xFF);
            buff[3] = SPI_ReadWriteByte(0xFF);

            //OCRɣƬѡø
            SD_CS_DISABLE();
            SPI_ReadWriteByte(0xFF);

            //յOCRеbit30λCCSȷΪSD2.0SDHC
            //CCS=1SDHC   CCS=0SD2.0
            if(buff[0]&0x40)    //CCS
            {
                SD_Type = SD_TYPE_V2HC;
            }
            else
            {
                SD_Type = SD_TYPE_V2;
            }
            //-----------SD2.0汾-----------

        /*  
	r1 = SD_SendCommand(CMD59, 0, 0x01);
        if(r1 != 0x00)
        {
            return r1;  //󣬷r1
        }
           
        //Sector Size
        r1 = SD_SendCommand(CMD16, 512, 0xff);
        if(r1 != 0x00)
        {
            return r1;  //󣬷r1
        } */          
            //SPIΪģʽ
         SPI_SetSpeed(1);  
        }

    }
    return r1;
}



/*******************************************************************************
* Function Name  : SD_ReceiveData
* Description    : SDжָȵݣڸλ
* Input          : u8 *data(Ŷݵڴ>len)
*                  u16 len(ݳȣ
*                  u8 release(ɺǷͷCSø 0ͷ 1ͷţ
* Output         : None
* Return         : u8 
*                  0NO_ERR
*                  otherϢ
*******************************************************************************/
u8 SD_ReceiveData(u8 *data, u16 len, u8 release)
{
    u16 retry;
    u8 r1;

    // һδ
    SD_CS_ENABLE();
    //ȴSDʼ0xFE
    retry = 0;
    do
    {
        r1 = SPI_ReadWriteByte(0xFF);
        retry++;
        if(retry>2000)  //2000εȴûӦ˳
        {
            SD_CS_DISABLE();
            return 1;
        }
    }while(r1 != 0xFE);
    //ʼ
    while(len--)
    {
        *data = SPI_ReadWriteByte(0xFF);
        data++;
    }
    //2αCRCdummy CRC
    SPI_ReadWriteByte(0xFF);
    SPI_ReadWriteByte(0xFF);
    //ͷߣCSø
    if(release == RELEASE)
    {
        //
        SD_CS_DISABLE();
        SPI_ReadWriteByte(0xFF);
    }

    return 0;
}


/*******************************************************************************
* Function Name  : SD_GetCID
* Description    : ȡSDCIDϢϢ
* Input          : u8 *cid_data(CIDڴ棬16Byte
* Output         : None
* Return         : u8 
*                  0NO_ERR
*                  1TIME_OUT
*                  otherϢ
*******************************************************************************/
u8 SD_GetCID(u8 *cid_data)
{
    u8 r1;

    //CMD10CID
    r1 = SD_SendCommand(CMD10, 0, 0xFF);
    if(r1 != 0x00)
    {
        return r1;  //ûȷӦ˳
    }
    //16ֽڵ
    SD_ReceiveData(cid_data, 16, RELEASE);

    return 0;
}


/*******************************************************************************
* Function Name  : SD_GetCSD
* Description    : ȡSDCSDϢٶϢ
* Input          : u8 *cid_data(CIDڴ棬16Byte
* Output         : None
* Return         : u8 
*                  0NO_ERR
*                  1TIME_OUT
*                  otherϢ
*******************************************************************************/
u8 SD_GetCSD(u8 *csd_data)
{
    u8 r1;

    //CMD9CSD
    r1 = SD_SendCommand(CMD9, 0, 0xFF);
    if(r1 != 0x00)
    {
        return r1;  //ûȷӦ˳
    }
    //16ֽڵ
    SD_ReceiveData(csd_data, 16, RELEASE);

    return 0;
}


/*******************************************************************************
* Function Name  : SD_GetCapacity
* Description    : ȡSD
* Input          : None
* Output         : None
* Return         : u32 capacity 
*                   0 ȡ 
*******************************************************************************/
u32 SD_GetCapacity(void)
{
    u8 csd[16];
    u32 Capacity;
    u8 r1;
    u16 i;
	u16 temp;

    //ȡCSDϢڼ0
    if(SD_GetCSD(csd)!=0)
    {
        return 0;
    }
       
    //ΪSDHC淽ʽ
    if((csd[0]&0xC0)==0x40)
    {
        Capacity =  (((u32)csd[8])<<8 + (u32)csd[9] +1)*(u32)1024;
    }
    else
    {
        //Ϊϰ汾
        ////////////formula of the capacity///////////////
        //
        //  memory capacity = BLOCKNR * BLOCK_LEN
        //	
        //	BLOCKNR = (C_SIZE + 1)* MULT
        //
        //           C_SIZE_MULT+2
        //	MULT = 2
        //
        //               READ_BL_LEN
        //	BLOCK_LEN = 2
        /**********************************************/
        //C_SIZE
    	i = csd[6]&0x03;
    	i<<=8;
    	i += csd[7];
    	i<<=2;
    	i += ((csd[8]&0xc0)>>6);
    
        //C_SIZE_MULT
    	r1 = csd[9]&0x03;
    	r1<<=1;
    	r1 += ((csd[10]&0x80)>>7);
    
        //BLOCKNR
    	r1+=2;
    	temp = 1;
    	while(r1)
    	{
    		temp*=2;
    		r1--;
    	}
    	Capacity = ((u32)(i+1))*((u32)temp);
    
        // READ_BL_LEN
    	i = csd[5]&0x0f;
        //BLOCK_LEN
    	temp = 1;
    	while(i)
    	{
    		temp*=2;
    		i--;
    	}
        //The final result
    	Capacity *= (u32)temp; 
    	//Capacity /= 512;
    }
    return (u32)Capacity;
}


/*******************************************************************************
* Function Name  : SD_ReadSingleBlock
* Description    : SDһblock
* Input          : u32 sector ȡַsectorֵַ 
*                  u8 *buffer ݴ洢ַС512byte 
* Output         : None
* Return         : u8 r1 
*                   0 ɹ
*                   otherʧ
*******************************************************************************/
u8 SD_ReadSingleBlock(u32 sector, u8 *buffer)
{
	u8 r1;

    //Ϊģʽ
    SPI_SetSpeed(SPI_SPEED_HIGH);
    
    //SDHCsectorַתbyteַ
    if(SD_Type!=SD_TYPE_V2HC)
    {
        sector = sector<<9;
    }

	r1 = SD_SendCommand(CMD17, sector, 0);//
	
	if(r1 != 0x00)
    {
        return r1;
    }
    
    r1 = SD_ReceiveData(buffer, 512, RELEASE);
    if(r1 != 0)
    {
        return r1;   //ݳ
    }
    else
    {
        return 0;
    }
}

/*******************************************************************************
* Function Name  : SD_WriteSingleBlock
* Description    : дSDһblock
* Input          : u32 sector ַsectorֵַ 
*                  u8 *buffer ݴ洢ַС512byte 
* Output         : None
* Return         : u8 r1 
*                   0 ɹ
*                   otherʧ
*******************************************************************************/
u8 SD_WriteSingleBlock(u32 sector, const u8 *data)
{
    u8 r1;
    u16 i;
    u16 retry;

    //Ϊģʽ
    SPI_SetSpeed(SPI_SPEED_HIGH);

    //SDHCsectorַתbyteַ
    if(SD_Type!=SD_TYPE_V2HC)
    {
        sector = sector<<9;
    }

    r1 = SD_SendCommand(CMD24, sector, 0x00);
    if(r1 != 0x00)
    {
        return r1;  //Ӧȷֱӷ
    }
    
    //ʼ׼ݴ
    SD_CS_ENABLE();
    //ȷ3ݣȴSD׼
    SPI_ReadWriteByte(0xff);
    SPI_ReadWriteByte(0xff);
    SPI_ReadWriteByte(0xff);
    //ʼ0xFE
    SPI_ReadWriteByte(0xFE);

    //һsector
    for(i=0;i<512;i++)
    {
        SPI_ReadWriteByte(*data++);
    }
    //2Bytedummy CRC
    SPI_ReadWriteByte(0xff);
    SPI_ReadWriteByte(0xff);
    
    //ȴSDӦ
    r1 = SPI_ReadWriteByte(0xff);
    if((r1&0x1F)!=0x05)
    {
        SD_CS_DISABLE();
        return r1;
    }
    
    //ȴ
    retry = 0;
    while(!SPI_ReadWriteByte(0xff))
    {
        retry++;
        if(retry>0xfffe)        //ʱдûɣ˳
        {
            SD_CS_DISABLE();
            return 1;           //д볬ʱ1
        }
    }

    //дɣƬѡ1
    SD_CS_DISABLE();
    SPI_ReadWriteByte(0xff);

    return 0;
}


/*******************************************************************************
* Function Name  : SD_ReadMultiBlock
* Description    : SDĶblock
* Input          : u32 sector ȡַsectorֵַ 
*                  u8 *buffer ݴ洢ַС512byte
*                  u8 count countblock
* Output         : None
* Return         : u8 r1 
*                   0 ɹ
*                   otherʧ
*******************************************************************************/
u8 SD_ReadMultiBlock(u32 sector, u8 *buffer, u8 count)
{
    u8 r1;

    //Ϊģʽ
    SPI_SetSpeed(SPI_SPEED_HIGH);
    
    //SDHCsectorַתbyteַ
    if(SD_Type!=SD_TYPE_V2HC)
    {
        sector = sector<<9;
    }
    //SD_WaitReady();
    //
	r1 = SD_SendCommand(CMD18, sector, 0);//
	if(r1 != 0x00)
    {
        return r1;
    }
    //ʼ
    do
    {
        if(SD_ReceiveData(buffer, 512, NO_RELEASE) != 0x00)
        {
            break;
        }
        buffer += 512;
    } while(--count);

    //ȫϣֹͣ
    SD_SendCommand(CMD12, 0, 0);
    //ͷ
    SD_CS_DISABLE();
    SPI_ReadWriteByte(0xFF);
    
    if(count != 0)
    {
        return count;   //ûд꣬ʣ
    }
    else
    {
        return 0;
    }
}


/*******************************************************************************
* Function Name  : SD_WriteMultiBlock
* Description    : дSDNblock
* Input          : u32 sector ַsectorֵַ 
*                  u8 *buffer ݴ洢ַС512byte
*                  u8 count дblockĿ
* Output         : None
* Return         : u8 r1 
*                   0 ɹ
*                   otherʧ
*******************************************************************************/
u8 SD_WriteMultiBlock(u32 sector, const u8 *data, u8 count)
{
    u8 r1;
    u16 i;

    //Ϊģʽ
    SPI_SetSpeed(SPI_SPEED_HIGH);

    //SDHCsectorַתbyteַ
    if(SD_Type != SD_TYPE_V2HC)
    {
        sector = sector<<9;
    }
    //Ŀ꿨MMCACMD23ָʹԤ
    if(SD_Type != SD_TYPE_MMC)
    {
        r1 = SD_SendCommand(ACMD23, count, 0x00);
    }
    //дָ
    r1 = SD_SendCommand(CMD25, sector, 0x00);
    if(r1 != 0x00)
    {
        return r1;  //Ӧȷֱӷ
    }
    
    //ʼ׼ݴ
    SD_CS_ENABLE();
    //ȷ3ݣȴSD׼
    SPI_ReadWriteByte(0xff);
    SPI_ReadWriteByte(0xff);

    //--------Nsectorдѭ
    do
    {
        //ʼ0xFC Ƕд
        SPI_ReadWriteByte(0xFC);
    
        //һsector
        for(i=0;i<512;i++)
        {
            SPI_ReadWriteByte(*data++);
        }
        //2Bytedummy CRC
        SPI_ReadWriteByte(0xff);
        SPI_ReadWriteByte(0xff);
        
        //ȴSDӦ
        r1 = SPI_ReadWriteByte(0xff);
        if((r1&0x1F)!=0x05)
        {
            SD_CS_DISABLE();    //ӦΪֱ˳
            return r1;
        }

        //ȴSDд
        if(SD_WaitReady()==1)
        {
            SD_CS_DISABLE();    //ȴSDдɳʱֱ˳
            return 1;
        }

        //sectorݴ
    }while(--count);
    
    //0xFD
    r1 = SPI_ReadWriteByte(0xFD);
    if(r1==0x00)
    {
        count =  0xfe;
    }

    if(SD_WaitReady())
    {
        while(1)
        {
        }
    }
    
    //дɣƬѡ1
    SD_CS_DISABLE();
    SPI_ReadWriteByte(0xff);

    return count;   //countֵдcount=0count=1
}

